define([
    'underscore',
    'backbone',
    'App',
    'modules/page/popup/popup-view',
    'text!modules/help/help.html',
    'modules/page/popup/external-nav-popup-view',
],
function (_, Backbone, app, PopupView, template, ExternalNavigationWarningPopup) {
    'use strict';

    return PopupView.extend({
        'template': _.template(template),
        'id': 'help',
        'events': _.extend({}, PopupView.prototype.events, {
            'popupafterclose': 'queuePopupOrDestroy',
            'click .external-link': 'openExternalLink',
        }),
        'queuePopupOrDestroy': function() {
            if (!this._preventDestroy) {
                this.destroy();
            } // else retain popup-view to show after cancelling opening external link
        },
        'openExternalLink': function(e) {
            var $link;
            var navigationWarning;

            e.preventDefault();

            $link = $(e.currentTarget);
            navigationWarning = new (ExternalNavigationWarningPopup.extend({focusOnElAfterClose: _.noop}))({
                elAfterClose: $link,
                model: new Backbone.Model({href: $link.attr('href')}),
            });

            this._preventDestroy = true;
            this.listenToOnce(navigationWarning, 'before:destroy', function() {
                this._preventDestroy = false;
                this.openPopup();
            });
            this.closePopup();
            navigationWarning.openPopup();
        },
        'templateContext': function() {
            return {vaFacilitiesLink: app.externalLinks.get('va-facilities')};
        },
    });
});
